Attribute VB_Name = "Module1"
Public Type QuadraticSolution
    X1 As Single
    X2 As Single
End Type

Public Function QuadraticEquation(a As Single, b As Single, c As Single) _
        As QuadraticSolution
        
    Dim delta As Single, Result As QuadraticSolution
    delta = b ^ 2 - 4 * a * c
    If delta < 0 Then
        Err.Raise 1000, , "No real roots"
    ElseIf delta = 0 Then
        Result.X1 = -b / (2 * a)
        Result.X2 = Result.X1
    Else
        Result.X1 = (-b - Sqr(delta)) / (2 * a)
        Result.X2 = (-b + Sqr(delta)) / (2 * a)
    End If
    QuadraticEquation = Result
    
End Function


